<?php
require __DIR__ . '/../app/db.php';
require __DIR__ . '/../app/auth.php';
require __DIR__ . '/../app/helpers.php';
require __DIR__ . '/../app/crypto.php';
require_login();

function paid_badge($date){
  if(!$date) return '<span class="badge badge--bad">نامشخص</span>';
  $ts = strtotime($date);
  $days = (int)floor(($ts - time()) / 86400);
  if ($days < 0) return '<span class="badge badge--bad">منقضی</span>';
  if ($days <= 7) return '<span class="badge badge--warn">نزدیک سررسید</span>';
  return '<span class="badge badge--good">تسویه</span>';
}

function sfp_label($v){
  if ($v === 'customer') return 'از مشتری';
  if ($v === 'provider') return 'از سرویس‌دهنده';
  return 'نامشخص';
}

$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT s.*, d.name AS dc_name FROM servers s JOIN datacenters d ON d.id=s.datacenter_id WHERE s.id=?");
$stmt->execute([$id]);
$r = $stmt->fetch();

if (!$r) { http_response_code(404); echo "یافت نشد"; exit; }

$title = "جزئیات سرور";
include __DIR__ . '/../partials/layout/head.php';
include __DIR__ . '/../partials/layout/nav.php';

$ilo_pass = is_admin() ? decrypt_text($r['ilo_password_enc']) : null;
?>
<div class="card">
  <div style="display:flex; gap:10px; flex-wrap:wrap; align-items:center; justify-content:space-between">
    <div>
      <div class="h1" style="margin:0">جزئیات سرور: <span class="mono"><?= e($r['server_serial']) ?></span></div>
      <div class="muted"><?= e($r['server_model']) ?> • <?= e($r['dc_name']) ?> • رک <?= e($r['rack_number']) ?> • یونیت <?= fa_num($r['unit_number']) ?></div>
    </div>
    <div style="display:flex; gap:10px; flex-wrap:wrap">
      <a class="btn" href="/team/servers.php">بازگشت</a>
      <?php if (is_admin()): ?>
        <a class="btn btn--brand" href="/admin/server_edit.php?id=<?= e($r['id']) ?>">ویرایش (ادمین)</a>
      <?php endif; ?>
    </div>
  </div>

  <div class="hr"></div>

  <div class="grid grid--2">
    <div class="card">
      <div class="h1">اطلاعات پایه</div>
      <div class="hr"></div>
      <div><b>نام مشتری:</b> <?= e($r['customer_name']) ?></div>
      <div><b>مدل سرور:</b> <?= e($r['server_model']) ?></div>
      <div><b>سریال:</b> <span class="mono"><?= e($r['server_serial']) ?></span></div>
      <div><b>دیتاسنتر:</b> <?= e($r['dc_name']) ?></div>
      <div><b>رک:</b> <span class="mono"><?= e($r['rack_number']) ?></span></div>
      <div><b>یونیت:</b> <span class="mono"><?= fa_num($r['unit_number']) ?></span></div>
      <div><b>آخرین بروزرسانی:</b> <span class="mono"><?= jalali_date($r['last_update']) ?></span></div>
    </div>

    <div class="card">
      <div class="h1">وضعیت تسویه سرویس</div>
      <div class="hr"></div>
      <div><b>تسویه تا تاریخ:</b> <span class="mono"><?= jalali_date($r['service_paid_until']) ?></span></div>
      <div style="margin-top:8px"><?= paid_badge($r['service_paid_until']) ?></div>
      <div class="muted" style="margin-top:10px; font-size:.9rem">کمتر از ۷ روز مانده = «نزدیک سررسید».</div>
    </div>
  </div>

  <div class="hr"></div>

  <div class="card">
    <div class="h1">سخت‌افزار</div>
    <div class="hr"></div>
    <div class="grid grid--3">
      <div class="card" style="padding:12px">
        <div class="muted">رم</div>
        <div style="font-weight:900">
          <?= $r['ram_total_gb'] ? fa_num($r['ram_total_gb']).' GB' : '-' ?>
        </div>
        <div class="muted" style="margin-top:6px">
          <?= $r['ram_modules_count'] ? 'تعداد ماژول: '.fa_num($r['ram_modules_count']) : '' ?>
          <?= ($r['ram_modules_count'] && $r['ram_freq_mhz']) ? ' • ' : '' ?>
          <?= $r['ram_freq_mhz'] ? 'فرکانس: '.fa_num($r['ram_freq_mhz']).' MHz' : '' ?>
        </div>
      </div>

      <div class="card" style="padding:12px">
        <div class="muted">CPU</div>
        <div style="font-weight:900"><?= e($r['cpu_model'] ?: '-') ?></div>
        <div class="muted" style="margin-top:6px"><?= $r['cpu_count'] ? 'تعداد CPU: '.fa_num($r['cpu_count']) : '' ?></div>
      </div>

      <div class="card" style="padding:12px">
        <div class="muted">شبکه</div>
        <div style="font-weight:900"><?= $r['nic_speed_gbps'] ? fa_num($r['nic_speed_gbps']).' Gbps' : '-' ?></div>
        <div class="muted" style="margin-top:6px">SFP: <?= e(sfp_label($r['sfp_owner'])) ?></div>
      </div>
    </div>

    <div class="hr"></div>

    <div class="grid grid--2">
      <div class="card">
        <div class="h1">NVMe</div>
        <div class="hr"></div>
        <div><b>ظرفیت:</b> <?= $r['nvme_capacity_gb'] ? fa_num($r['nvme_capacity_gb']).' GB' : '-' ?></div>
        <div><b>مدل:</b> <span class="mono"><?= e($r['nvme_model'] ?: '-') ?></span></div>
        <div><b>سریال:</b> <span class="mono"><?= e($r['nvme_serial'] ?: '-') ?></span></div>
      </div>

      <div class="card">
        <div class="h1">SAS</div>
        <div class="hr"></div>
        <div class="muted" style="white-space:pre-wrap"><?= e($r['sas_drives'] ?: '—') ?></div>
      </div>
    </div>
  </div>

  <div class="hr"></div>

  <div class="grid grid--2">
    <div class="card">
      <div class="h1">شبکه</div>
      <div class="hr"></div>
      <div><b>IP Range 1:</b> <span class="mono"><?= e($r['ip_range_1']) ?></span></div>
      <div><b>IP Range 2:</b> <span class="mono"><?= e($r['ip_range_2']) ?></span></div>
      <div><b>IP Range 3:</b> <span class="mono"><?= e($r['ip_range_3']) ?></span></div>
      <div><b>IP Range 4:</b> <span class="mono"><?= e($r['ip_range_4']) ?></span></div>
      <div><b>پورت سوئیچ:</b> <span class="mono"><?= e($r['switch_port_name']) ?></span></div>
    </div>

    <div class="card">
      <div class="h1">ILO / مدیریت</div>
      <div class="hr"></div>
      <div><b>ILO IP:</b> <span class="mono"><?= e($r['ilo_ip']) ?></span></div>
      <div><b>ILO User:</b> <span class="mono"><?= e($r['ilo_username']) ?></span></div>
      <div>
        <b>ILO Password:</b>
        <?php if (is_admin()): ?>
          <span class="mono"><?= e($ilo_pass ?? '-') ?></span>
          <span class="badge badge--good">ادمین</span>
        <?php else: ?>
          <span class="badge badge--warn">مخفی برای ویوِر</span>
        <?php endif; ?>
      </div>
      <div class="hr"></div>
      <div><b>ترافیک تسویه‌شده (TB):</b> <?= fa_num($r['billing_traffic_tb']) ?></div>
      <div class="hr"></div>
      <div><b>یادداشت:</b></div>
      <div class="muted" style="white-space:pre-wrap"><?= e($r['notes']) ?></div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../partials/layout/foot.php'; ?>
