<?php
require __DIR__ . '/../app/db.php';
require __DIR__ . '/../app/auth.php';
require __DIR__ . '/../app/helpers.php';
require_role('admin');

$dc = trim($_GET['dc'] ?? '');
$q  = trim($_GET['q'] ?? '');

$dc_rows = $pdo->query("SELECT id,name FROM datacenters ORDER BY name ASC")->fetchAll();

$sql = "SELECT s.*, d.name AS dc_name
        FROM servers s
        JOIN datacenters d ON d.id = s.datacenter_id
        WHERE 1=1 ";
$params = [];
if ($dc !== '') { $sql .= " AND d.id = ? "; $params[] = $dc; }
if ($q !== '') {
  $sql .= " AND (
    s.customer_name LIKE ? OR s.server_model LIKE ? OR s.server_serial LIKE ? OR
    s.ip_range_1 LIKE ? OR s.ip_range_2 LIKE ? OR s.ip_range_3 LIKE ? OR s.ip_range_4 LIKE ? OR
    s.switch_port_name LIKE ? OR s.ilo_ip LIKE ? OR s.ilo_username LIKE ? OR
    s.cpu_model LIKE ? OR s.nvme_model LIKE ? OR s.nvme_serial LIKE ? OR s.sas_drives LIKE ?
  ) ";
  $like = "%$q%";
  array_push($params, $like,$like,$like,$like,$like,$like,$like,$like,$like,$like,$like,$like,$like,$like);
}
$sql .= " ORDER BY s.updated_at DESC LIMIT 2000";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

if (($_GET['export'] ?? '') === 'csv') {
  header('Content-Type: text/csv; charset=utf-8');
  header('Content-Disposition: attachment; filename="servers_export.csv"');
  $out = fopen('php://output', 'w');
  fputcsv($out, [
    'customer','model','serial','rack','unit','datacenter',
    'ram_total_gb','ram_modules_count','ram_freq_mhz','cpu_model','cpu_count','nic_speed_gbps','sfp_owner',
    'nvme_capacity_gb','nvme_model','nvme_serial','sas_drives',
    'ip1','ip2','ip3','ip4','switch_port',
    'ilo_ip','ilo_user','traffic_tb','service_paid_until','last_update','notes'
  ]);
  foreach ($rows as $r) {
    fputcsv($out, [
      $r['customer_name'],$r['server_model'],$r['server_serial'],$r['rack_number'],$r['unit_number'],$r['dc_name'],
      $r['ram_total_gb'],$r['ram_modules_count'],$r['ram_freq_mhz'],$r['cpu_model'],$r['cpu_count'],$r['nic_speed_gbps'],$r['sfp_owner'],
      $r['nvme_capacity_gb'],$r['nvme_model'],$r['nvme_serial'],$r['sas_drives'],
      $r['ip_range_1'],$r['ip_range_2'],$r['ip_range_3'],$r['ip_range_4'],$r['switch_port_name'],
      $r['ilo_ip'],$r['ilo_username'],$r['billing_traffic_tb'],$r['service_paid_until'],$r['last_update'],$r['notes']
    ]);
  }
  fclose($out);
  exit;
}

$title = "مدیریت سرورها";
include __DIR__ . '/../partials/layout/head.php';
include __DIR__ . '/../partials/layout/nav.php';
?>
<div class="card">
  <div style="display:flex; gap:10px; flex-wrap:wrap; align-items:center; justify-content:space-between">
    <div>
      <div class="h1" style="margin:0">مدیریت سرورها</div>
      <div class="muted">CRUD کامل + خروجی CSV • شامل سخت‌افزار و تاریخ تسویه</div>
    </div>
    <div class="actions">
      <a class="btn btn--brand" href="/admin/server_create.php">+ افزودن</a>
      <a class="btn" href="/admin/servers_list.php?export=csv&dc=<?= e($dc) ?>&q=<?= e($q) ?>">دانلود CSV</a>
    </div>
  </div>

  <div class="hr"></div>

  <form class="form" method="get">
    <div class="row row--2">
      <div class="field">
        <label>دیتاسنتر</label>
        <select name="dc">
          <option value="">همه</option>
          <?php foreach($dc_rows as $d): ?>
            <option value="<?= e($d['id']) ?>" <?= ($dc == (string)$d['id']) ? 'selected' : '' ?>><?= e($d['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="field">
        <label>جستجو</label>
        <input name="q" placeholder="سریال، مدل، IP، CPU، NVMe..." value="<?= e($q) ?>">
      </div>
    </div>
    <div style="display:flex; gap:10px; flex-wrap:wrap">
      <button class="btn btn--brand" type="submit">اعمال فیلتر</button>
      <a class="btn" href="/admin/servers_list.php">پاک کردن</a>
    </div>
  </form>

  <div class="hr"></div>

  <div class="muted">جستجو داخل جدول (کلاینت‌ساید):</div>
  <div class="field" style="margin-top:10px" data-filter-table>
    <input data-table-search placeholder="جستجو..." />
  </div>

  <div class="hr"></div>

  <div class="tablewrap">
    <table>
      <thead>
        <tr>
          <th>سریال</th><th>مدل</th><th>مشتری</th><th>دیتاسنتر</th><th>رک</th><th>یونیت</th>
          <th>تسویه تا</th>
          <th>RAM</th><th>CPU</th><th>NIC</th>
          <th>NVMe</th>
          <th>عملیات</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><a class="link" href="/team/server.php?id=<?= e($r['id']) ?>"><?= e($r['server_serial']) ?></a></td>
            <td><?= e($r['server_model']) ?></td>
            <td><?= e($r['customer_name']) ?></td>
            <td><?= e($r['dc_name']) ?></td>
            <td class="mono"><?= e($r['rack_number']) ?></td>
            <td class="mono"><?= fa_num($r['unit_number']) ?></td>
            <td class="mono"><?= jalali_date($r['service_paid_until']) ?></td>
            <td class="mono"><?= $r['ram_total_gb'] ? fa_num($r['ram_total_gb']).'GB' : '-' ?></td>
            <td class="mono"><?= e($r['cpu_model'] ?: '-') ?></td>
            <td class="mono"><?= $r['nic_speed_gbps'] ? fa_num($r['nic_speed_gbps']).'G' : '-' ?></td>
            <td class="mono"><?= e($r['nvme_model'] ?: '-') ?></td>
            <td class="actions">
              <a class="btn" href="/admin/server_edit.php?id=<?= e($r['id']) ?>">ویرایش</a>
              <a class="btn btn--danger" href="/admin/server_delete.php?id=<?= e($r['id']) ?>" onclick="return confirm('حذف شود؟')">حذف</a>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (!count($rows)): ?>
          <tr><td colspan="12" class="muted">هیچ موردی یافت نشد.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include __DIR__ . '/../partials/layout/foot.php'; ?>
