<?php
require __DIR__ . '/../app/db.php';
require __DIR__ . '/../app/auth.php';
require __DIR__ . '/../app/helpers.php';
require __DIR__ . '/../app/csrf.php';
require __DIR__ . '/../app/crypto.php';
require_role('admin');

$id = (int)($_GET['id'] ?? 0);
$dc_rows = $pdo->query("SELECT id,name FROM datacenters ORDER BY name ASC")->fetchAll();

$stmt = $pdo->prepare("SELECT * FROM servers WHERE id=?");
$stmt->execute([$id]);
$values = $stmt->fetch();
if (!$values) { http_response_code(404); echo "یافت نشد"; exit; }

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  verify_csrf();

  $values['customer_name'] = trim($_POST['customer_name'] ?? '');
  $values['server_model'] = trim($_POST['server_model'] ?? '');
  $values['server_serial'] = trim($_POST['server_serial'] ?? '');
  $values['rack_number'] = trim($_POST['rack_number'] ?? '');
  $values['unit_number'] = (int)($_POST['unit_number'] ?? 0);
  $values['datacenter_id'] = (int)($_POST['datacenter_id'] ?? 0);

  $values['ram_total_gb'] = ($_POST['ram_total_gb'] ?? '') !== '' ? (int)$_POST['ram_total_gb'] : null;
  $values['ram_modules_count'] = ($_POST['ram_modules_count'] ?? '') !== '' ? (int)$_POST['ram_modules_count'] : null;
  $values['ram_freq_mhz'] = ($_POST['ram_freq_mhz'] ?? '') !== '' ? (int)$_POST['ram_freq_mhz'] : null;
  $values['cpu_model'] = trim($_POST['cpu_model'] ?? '');
  $values['cpu_count'] = ($_POST['cpu_count'] ?? '') !== '' ? (int)$_POST['cpu_count'] : null;
  $values['nic_speed_gbps'] = ($_POST['nic_speed_gbps'] ?? '') !== '' ? (int)$_POST['nic_speed_gbps'] : null;
  $values['sfp_owner'] = ($_POST['sfp_owner'] ?? '') ?: null;
  $values['nvme_capacity_gb'] = ($_POST['nvme_capacity_gb'] ?? '') !== '' ? (int)$_POST['nvme_capacity_gb'] : null;
  $values['nvme_model'] = trim($_POST['nvme_model'] ?? '');
  $values['nvme_serial'] = trim($_POST['nvme_serial'] ?? '');
  $values['sas_drives'] = trim($_POST['sas_drives'] ?? '');

  $values['ip_range_1'] = trim($_POST['ip_range_1'] ?? '');
  $values['ip_range_2'] = trim($_POST['ip_range_2'] ?? '');
  $values['ip_range_3'] = trim($_POST['ip_range_3'] ?? '');
  $values['ip_range_4'] = trim($_POST['ip_range_4'] ?? '');

  $values['switch_port_name'] = trim($_POST['switch_port_name'] ?? '');
  $values['ilo_ip'] = trim($_POST['ilo_ip'] ?? '');
  $values['ilo_username'] = trim($_POST['ilo_username'] ?? '');
  $ilo_password = trim($_POST['ilo_password'] ?? '');

  $values['billing_traffic_tb'] = ($_POST['billing_traffic_tb'] ?? '') !== '' ? (float)$_POST['billing_traffic_tb'] : null;
  $values['service_paid_until'] = ($_POST['service_paid_until'] ?? '') ?: null;
  $values['last_update'] = ($_POST['last_update'] ?? '') ?: null;
  $values['notes'] = trim($_POST['notes'] ?? '');

  if ($values['customer_name'] === '') $errors[] = 'نام مشتری الزامی است.';
  if ($values['server_model'] === '') $errors[] = 'مدل سرور الزامی است.';
  if ($values['server_serial'] === '') $errors[] = 'سریال الزامی است.';
  if ($values['rack_number'] === '') $errors[] = 'شماره رک الزامی است.';
  if ($values['unit_number'] <= 0) $errors[] = 'شماره یونیت معتبر نیست.';
  if ($values['datacenter_id'] <= 0) $errors[] = 'دیتاسنتر را انتخاب کنید.';
  if ($values['sfp_owner'] !== null && !in_array($values['sfp_owner'], ['customer','provider'], true)) $errors[] = 'مقدار SFP نامعتبر است.';

  if (!$errors) {
    try {
      $sql = "UPDATE servers SET
        customer_name=?, server_model=?, server_serial=?, rack_number=?, unit_number=?, datacenter_id=?,
        ram_total_gb=?, ram_modules_count=?, ram_freq_mhz=?, cpu_model=?, cpu_count=?, nic_speed_gbps=?, sfp_owner=?,
        nvme_capacity_gb=?, nvme_model=?, nvme_serial=?, sas_drives=?,
        ip_range_1=?, ip_range_2=?, ip_range_3=?, ip_range_4=?,
        switch_port_name=?, ilo_ip=?, ilo_username=?,
        billing_traffic_tb=?, service_paid_until=?, last_update=?, notes=?";
      $params = [
        $values['customer_name'], $values['server_model'], $values['server_serial'],
        $values['rack_number'], $values['unit_number'], $values['datacenter_id'],

        $values['ram_total_gb'], $values['ram_modules_count'], $values['ram_freq_mhz'],
        ($values['cpu_model'] ?: null), $values['cpu_count'],
        $values['nic_speed_gbps'], $values['sfp_owner'],

        $values['nvme_capacity_gb'], ($values['nvme_model'] ?: null), ($values['nvme_serial'] ?: null), ($values['sas_drives'] ?: null),

        $values['ip_range_1'] ?: null, $values['ip_range_2'] ?: null, $values['ip_range_3'] ?: null, $values['ip_range_4'] ?: null,
        $values['switch_port_name'] ?: null,
        $values['ilo_ip'] ?: null, $values['ilo_username'] ?: null,

        $values['billing_traffic_tb'],
        $values['service_paid_until'],
        $values['last_update'],
        $values['notes'] ?: null
      ];

      if ($ilo_password !== '') {
        $sql .= ", ilo_password_enc=?";
        $params[] = encrypt_text($ilo_password);
      }
      $sql .= " WHERE id=?";
      $params[] = $id;

      $stmt2 = $pdo->prepare($sql);
      $stmt2->execute($params);

      redirect('/admin/servers_list.php');
    } catch (Throwable $e) {
      $errors[] = 'خطا در ذخیره. احتمالاً سریال تکراری است.';
    }
  }
}

$title = "ویرایش سرور";
include __DIR__ . '/../partials/layout/head.php';
include __DIR__ . '/../partials/layout/nav.php';
?>
<div class="card">
  <div style="display:flex; gap:10px; flex-wrap:wrap; align-items:center; justify-content:space-between">
    <div>
      <div class="h1" style="margin:0">ویرایش سرور</div>
      <div class="muted">سریال: <span class="mono"><?= e($values['server_serial']) ?></span></div>
    </div>
    <a class="btn" href="/team/server.php?id=<?= e($id) ?>">مشاهده در پنل تیم</a>
  </div>
  <div class="hr"></div>
  <?php
    $mode='edit';
    $action='/admin/server_edit.php?id=' . $id;
    $show_password_value=false;
    $password_plain=null;
    include __DIR__ . '/_server_form.php';
  ?>
</div>
<?php include __DIR__ . '/../partials/layout/foot.php'; ?>
