<?php
require __DIR__ . '/../app/db.php';
require __DIR__ . '/../app/auth.php';
require __DIR__ . '/../app/helpers.php';
require __DIR__ . '/../app/csrf.php';
require __DIR__ . '/../app/crypto.php';
require_role('admin');

$dc_rows = $pdo->query("SELECT id,name FROM datacenters ORDER BY name ASC")->fetchAll();
$values = [
  'last_update' => date('Y-m-d')
];
$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  verify_csrf();
  $values = [
    'customer_name' => trim($_POST['customer_name'] ?? ''),
    'server_model' => trim($_POST['server_model'] ?? ''),
    'server_serial' => trim($_POST['server_serial'] ?? ''),
    'rack_number' => trim($_POST['rack_number'] ?? ''),
    'unit_number' => (int)($_POST['unit_number'] ?? 0),
    'datacenter_id' => (int)($_POST['datacenter_id'] ?? 0),

    'ram_total_gb' => ($_POST['ram_total_gb'] ?? '') !== '' ? (int)$_POST['ram_total_gb'] : null,
    'ram_modules_count' => ($_POST['ram_modules_count'] ?? '') !== '' ? (int)$_POST['ram_modules_count'] : null,
    'ram_freq_mhz' => ($_POST['ram_freq_mhz'] ?? '') !== '' ? (int)$_POST['ram_freq_mhz'] : null,
    'cpu_model' => trim($_POST['cpu_model'] ?? ''),
    'cpu_count' => ($_POST['cpu_count'] ?? '') !== '' ? (int)$_POST['cpu_count'] : null,
    'nic_speed_gbps' => ($_POST['nic_speed_gbps'] ?? '') !== '' ? (int)$_POST['nic_speed_gbps'] : null,
    'sfp_owner' => ($_POST['sfp_owner'] ?? '') ?: null,
    'nvme_capacity_gb' => ($_POST['nvme_capacity_gb'] ?? '') !== '' ? (int)$_POST['nvme_capacity_gb'] : null,
    'nvme_model' => trim($_POST['nvme_model'] ?? ''),
    'nvme_serial' => trim($_POST['nvme_serial'] ?? ''),
    'sas_drives' => trim($_POST['sas_drives'] ?? ''),

    'ip_range_1' => trim($_POST['ip_range_1'] ?? ''),
    'ip_range_2' => trim($_POST['ip_range_2'] ?? ''),
    'ip_range_3' => trim($_POST['ip_range_3'] ?? ''),
    'ip_range_4' => trim($_POST['ip_range_4'] ?? ''),
    'switch_port_name' => trim($_POST['switch_port_name'] ?? ''),
    'ilo_ip' => trim($_POST['ilo_ip'] ?? ''),
    'ilo_username' => trim($_POST['ilo_username'] ?? ''),
    'billing_traffic_tb' => ($_POST['billing_traffic_tb'] ?? '') !== '' ? (float)$_POST['billing_traffic_tb'] : null,
    'service_paid_until' => ($_POST['service_paid_until'] ?? '') ?: null,
    'last_update' => ($_POST['last_update'] ?? '') ?: null,
    'notes' => trim($_POST['notes'] ?? ''),
  ];
  $ilo_password = trim($_POST['ilo_password'] ?? '');

  if ($values['customer_name'] === '') $errors[] = 'نام مشتری الزامی است.';
  if ($values['server_model'] === '') $errors[] = 'مدل سرور الزامی است.';
  if ($values['server_serial'] === '') $errors[] = 'سریال الزامی است.';
  if ($values['rack_number'] === '') $errors[] = 'شماره رک الزامی است.';
  if ($values['unit_number'] <= 0) $errors[] = 'شماره یونیت معتبر نیست.';
  if ($values['datacenter_id'] <= 0) $errors[] = 'دیتاسنتر را انتخاب کنید.';
  if ($values['sfp_owner'] !== null && !in_array($values['sfp_owner'], ['customer','provider'], true)) $errors[] = 'مقدار SFP نامعتبر است.';

  if (!$errors) {
    try {
      $stmt = $pdo->prepare("INSERT INTO servers
        (customer_name, server_model, server_serial, rack_number, unit_number, datacenter_id,
         ram_total_gb, ram_modules_count, ram_freq_mhz, cpu_model, cpu_count, nic_speed_gbps, sfp_owner,
         nvme_capacity_gb, nvme_model, nvme_serial, sas_drives,
         ip_range_1, ip_range_2, ip_range_3, ip_range_4,
         switch_port_name, ilo_ip, ilo_username, ilo_password_enc,
         billing_traffic_tb, service_paid_until, last_update, notes)
        VALUES (?,?,?,?,?,?,
                ?,?,?,?,?,?,?,
                ?,?,?,?,
                ?,?,?,?,
                ?,?,?,?,
                ?,?,?,?,
                ?,?,?,?)");

      $stmt->execute([
        $values['customer_name'], $values['server_model'], $values['server_serial'],
        $values['rack_number'], $values['unit_number'], $values['datacenter_id'],

        $values['ram_total_gb'], $values['ram_modules_count'], $values['ram_freq_mhz'],
        ($values['cpu_model'] ?: null), $values['cpu_count'],
        $values['nic_speed_gbps'], $values['sfp_owner'],

        $values['nvme_capacity_gb'], ($values['nvme_model'] ?: null), ($values['nvme_serial'] ?: null), ($values['sas_drives'] ?: null),

        $values['ip_range_1'] ?: null, $values['ip_range_2'] ?: null, $values['ip_range_3'] ?: null, $values['ip_range_4'] ?: null,
        $values['switch_port_name'] ?: null,
        $values['ilo_ip'] ?: null, $values['ilo_username'] ?: null,
        encrypt_text($ilo_password),

        $values['billing_traffic_tb'],
        $values['service_paid_until'],
        $values['last_update'],
        $values['notes'] ?: null
      ]);

      redirect('/admin/servers_list.php');
    } catch (Throwable $e) {
      $errors[] = 'خطا در ذخیره. احتمالاً سریال تکراری است یا دیتابیس مشکل دارد.';
    }
  }
}

$title = "افزودن سرور";
include __DIR__ . '/../partials/layout/head.php';
include __DIR__ . '/../partials/layout/nav.php';
?>
<div class="card">
  <div class="h1">افزودن سرور جدید</div>
  <div class="muted">فیلدهای سخت‌افزار + تسویه سرویس تا تاریخ + 4 رنج IP + ذخیره امن رمز ILO</div>
  <div class="hr"></div>
  <?php
    $mode='create';
    $action='/admin/server_create.php';
    $show_password_value=false;
    $password_plain=null;
    include __DIR__ . '/_server_form.php';
  ?>
</div>
<?php include __DIR__ . '/../partials/layout/foot.php'; ?>
