<?php
// expects: $mode ('create'|'edit'), $values, $dc_rows, $errors, $action, $show_password_value (bool), $password_plain (string|null)
?>
<form class="form" method="post" action="<?= e($action) ?>">
  <?= csrf_field() ?>

  <?php if ($errors): ?>
    <div class="alert alert--bad">
      <b>لطفاً موارد زیر را بررسی کنید:</b>
      <ul>
        <?php foreach($errors as $er): ?><li><?= e($er) ?></li><?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>

  <div class="row row--2">
    <div class="field">
      <label>نام مشتری</label>
      <input name="customer_name" required value="<?= e($values['customer_name'] ?? '') ?>" placeholder="مثلاً شرکت Acme">
    </div>
    <div class="field">
      <label>مدل سرور</label>
      <input name="server_model" required value="<?= e($values['server_model'] ?? '') ?>" placeholder="Dell PowerEdge R740">
    </div>
  </div>

  <div class="row row--2">
    <div class="field">
      <label>شماره سریال</label>
      <input name="server_serial" required value="<?= e($values['server_serial'] ?? '') ?>" placeholder="CN-XXXXXX">
    </div>
    <div class="field">
      <label>دیتاسنتر</label>
      <select name="datacenter_id" required>
        <option value="">انتخاب کنید</option>
        <?php foreach($dc_rows as $d): ?>
          <option value="<?= e($d['id']) ?>" <?= ((string)($values['datacenter_id'] ?? '') === (string)$d['id']) ? 'selected' : '' ?>>
            <?= e($d['name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
  </div>

  <div class="row row--3">
    <div class="field">
      <label>شماره رک</label>
      <input name="rack_number" required value="<?= e($values['rack_number'] ?? '') ?>" placeholder="R12">
    </div>
    <div class="field">
      <label>شماره یونیت</label>
      <input name="unit_number" type="number" min="1" max="60" required value="<?= e($values['unit_number'] ?? '') ?>" placeholder="18">
    </div>
    <div class="field">
      <label>ترافیک تسویه‌شده (TB)</label>
      <input name="billing_traffic_tb" type="number" step="0.01" min="0" max="10000" value="<?= e($values['billing_traffic_tb'] ?? '') ?>" placeholder="مثلاً 12.5">
    </div>
  </div>

  <div class="row row--2">
    <div class="field">
      <label>تسویه سرویس تا تاریخ</label>
      <input name="service_paid_until" type="date" value="<?= e($values['service_paid_until'] ?? '') ?>">
      <div class="muted" style="font-size:.85rem; margin-top:6px">یعنی سرویس تا این تاریخ تسویه شده است.</div>
    </div>
    <div class="field">
      <label>آخرین بروزرسانی</label>
      <input name="last_update" type="date" value="<?= e($values['last_update'] ?? '') ?>">
    </div>
  </div>

  <div class="card" style="padding:14px">
    <div class="h1">سخت‌افزار</div>
    <div class="muted">برای ثبت مشخصات فنی دقیق سرور</div>
    <div class="hr"></div>

    <div class="row row--3">
      <div class="field">
        <label>رم (GB)</label>
        <input name="ram_total_gb" type="number" min="0" value="<?= e($values['ram_total_gb'] ?? '') ?>" placeholder="مثلاً 128">
      </div>
      <div class="field">
        <label>تعداد رم (ماژول)</label>
        <input name="ram_modules_count" type="number" min="0" value="<?= e($values['ram_modules_count'] ?? '') ?>" placeholder="مثلاً 8">
      </div>
      <div class="field">
        <label>فرکانس رم (MHz)</label>
        <input name="ram_freq_mhz" type="number" min="0" value="<?= e($values['ram_freq_mhz'] ?? '') ?>" placeholder="مثلاً 2666">
      </div>
    </div>

    <div class="row row--2">
      <div class="field">
        <label>مدل CPU</label>
        <input name="cpu_model" value="<?= e($values['cpu_model'] ?? '') ?>" placeholder="مثلاً Intel Xeon Silver 4210">
      </div>
      <div class="field">
        <label>تعداد CPU</label>
        <input name="cpu_count" type="number" min="0" value="<?= e($values['cpu_count'] ?? '') ?>" placeholder="مثلاً 2">
      </div>
    </div>

    <div class="row row--2">
      <div class="field">
        <label>سرعت کارت شبکه (Gbps)</label>
        <input name="nic_speed_gbps" type="number" min="0" value="<?= e($values['nic_speed_gbps'] ?? '') ?>" placeholder="مثلاً 10">
      </div>
      <div class="field">
        <label>SFP مال کیست؟</label>
        <select name="sfp_owner">
          <option value="">نامشخص</option>
          <option value="customer" <?= (($values['sfp_owner'] ?? '') === 'customer') ? 'selected' : '' ?>>از مشتری</option>
          <option value="provider" <?= (($values['sfp_owner'] ?? '') === 'provider') ? 'selected' : '' ?>>از سرویس‌دهنده</option>
        </select>
      </div>
    </div>

    <div class="row row--3">
      <div class="field">
        <label>NVMe ظرفیت (GB)</label>
        <input name="nvme_capacity_gb" type="number" min="0" value="<?= e($values['nvme_capacity_gb'] ?? '') ?>" placeholder="مثلاً 1000">
      </div>
      <div class="field">
        <label>NVMe مدل</label>
        <input name="nvme_model" value="<?= e($values['nvme_model'] ?? '') ?>" placeholder="Samsung PM9A3 / Intel P4510">
      </div>
      <div class="field">
        <label>NVMe سریال</label>
        <input name="nvme_serial" value="<?= e($values['nvme_serial'] ?? '') ?>" placeholder="SN-XXXX">
      </div>
    </div>

    <div class="field">
      <label>هاردهای SAS</label>
      <textarea name="sas_drives" placeholder="هر خط یک هارد: ظرفیت | برند | سریال
مثال:
1200GB | Seagate | ZC1234...
600GB | HGST | 1WJ...."><?= e($values['sas_drives'] ?? '') ?></textarea>
      <div class="muted" style="font-size:.85rem; margin-top:6px">هر خط یک هارد (ظرفیت/برند/سریال). برای جستجو و گزارش‌گیری هم مناسب است.</div>
    </div>
  </div>

  <div class="row row--2">
    <div class="field">
      <label>IP Range 1</label>
      <input name="ip_range_1" value="<?= e($values['ip_range_1'] ?? '') ?>" placeholder="185.10.20.30-185.10.20.31 یا CIDR">
    </div>
    <div class="field">
      <label>IP Range 2</label>
      <input name="ip_range_2" value="<?= e($values['ip_range_2'] ?? '') ?>">
    </div>
  </div>

  <div class="row row--2">
    <div class="field">
      <label>IP Range 3</label>
      <input name="ip_range_3" value="<?= e($values['ip_range_3'] ?? '') ?>">
    </div>
    <div class="field">
      <label>IP Range 4</label>
      <input name="ip_range_4" value="<?= e($values['ip_range_4'] ?? '') ?>">
    </div>
  </div>

  <div class="row row--2">
    <div class="field">
      <label>نام پورت کارت شبکه در سوئیچ</label>
      <input name="switch_port_name" value="<?= e($values['switch_port_name'] ?? '') ?>" placeholder="SW1-Gi1/0/24">
    </div>
    <div class="field">
      <label>—</label>
      <input disabled value="">
    </div>
  </div>

  <div class="card" style="padding:14px">
    <div class="h1">اطلاعات ILO</div>
    <div class="muted">رمز ILO به صورت رمزنگاری‌شده ذخیره می‌شود و فقط ادمین‌ها می‌بینند.</div>
    <div class="hr"></div>

    <div class="row row--3">
      <div class="field">
        <label>ILO IP</label>
        <input name="ilo_ip" value="<?= e($values['ilo_ip'] ?? '') ?>" placeholder="192.168.10.15">
      </div>
      <div class="field">
        <label>ILO Username</label>
        <input name="ilo_username" value="<?= e($values['ilo_username'] ?? '') ?>" placeholder="admin">
      </div>
      <div class="field">
        <label>ILO Password</label>
        <input name="ilo_password" value="<?= e($show_password_value ? ($password_plain ?? '') : '') ?>" placeholder="<?= $mode==='edit' ? 'برای تغییر وارد کنید (خالی = بدون تغییر)' : '' ?>">
      </div>
    </div>
  </div>

  <div class="field">
    <label>یادداشت</label>
    <textarea name="notes" placeholder="RAID, PSU, وضعیت، ..."><?= e($values['notes'] ?? '') ?></textarea>
  </div>

  <div style="display:flex; gap:10px; flex-wrap:wrap">
    <button class="btn btn--brand" type="submit"><?= $mode==='create' ? 'ثبت سرور' : 'ذخیره تغییرات' ?></button>
    <a class="btn" href="/admin/servers_list.php">انصراف</a>
  </div>
</form>
